/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include "ActiveLAyer.h"    // header for Resources in ActiveLayer.DLL
 
enum {ID_X1, ID_X2, ID_Y1, ID_Y2, NUM_CONTROLS};// for accessing the asCntrlText elements

class CActiveLayerDlg : public Dialog
{
public:
	CActiveLayerDlg() : Dialog( IDD_ACTIVELAYER_DLG, "ActiveLayer" )
	{
		
	}
	
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		
		//Launch the modeless dialog
		int nRet = Dialog::Create(hParent);
		
		return nRet;
	}

protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_CHANGE_LAYER( OnActiveLayerChange )
	ON_CHANGE_PAGE( OnActivePageChange )
	ON_CHANGE_DATASET( OnActiveDatasetChange )
	ON_CHANGE_SELECTION( OnSelectionChange )
	ON_ORIGIN_CHANGE(SN_COL_CHANGE_FORMAT, OnColFormatChange)
	ON_ORIGIN_CHANGE(SN_COL_CHANGE_PLOT_DESIGNATION, OnPlotAsChange)
	ON_OBJECT_MODIFY(OnOriginModify)		/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	ON_OBJECT_INFO_MODIFY(OnOriginModify)		/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	
	//----- CPY 10/27/2007 QA70-10600 PAGE_CREATE_DESTROY_MSGS
	ON_PAGE_CREATE(OnPageCreate)
	ON_PAGE_DESTROY(OnPageDestroy)
	//-----

EVENTS_END
	BOOL OnInitDialog()
	{
		// initialize your controls
		m_cntrlActivePage = GetItem( IDC_ACTIVE_PAGE );
		m_cntrlActiveCurve = GetItem( IDC_ACTIVE_CURVE );	
		
		// initialize the dialog
		OnActivePageChange(); 
		OnActiveLayerChange();
		OnActiveDatasetChange();
		
		return TRUE;
	}
	
	
	// get the information of GraphLayer
	BOOL OnActiveLayerChange( void )
	{
		out_str("OnActiveLayerChange");
		GraphLayer gLayer = Project.ActiveLayer();
		int nResIDs[NUM_CONTROLS] = {IDC_ACTIVE_LAYER_X1, IDC_ACTIVE_LAYER_X2, IDC_ACTIVE_LAYER_Y1, IDC_ACTIVE_LAYER_Y2};
		vector<string> asCntrlText(NUM_CONTROLS);
		
		if(gLayer) // make sure we have a graph layer, if wks active, GraphLayer will not cast and we get NULL 
		{
			// directly assign double to string will just use default formatting, you can format the strings if you want
			asCntrlText[ID_X1] = gLayer.X.From;
			asCntrlText[ID_X2] = gLayer.X.To;
			asCntrlText[ID_Y1] = gLayer.Y.From;
			asCntrlText[ID_Y2] = gLayer.Y.To;
		}
		
		for(int ii = 0; ii < NUM_CONTROLS; ii++)
		{
			Control cntrl = GetItem( nResIDs[ii] ); 
			if(cntrl)
				cntrl.Text = asCntrlText[ii];
		}
			
		return TRUE;
	} 
	
	// get the name of the page
	BOOL OnActivePageChange( void )
	{
		// Get all Check Box controls
		Page	active = Project.Pages(); // Pages is a collection, so default will get active
		m_cntrlActivePage.Text = active.GetName();					
		return TRUE;
	}
	
	// get the information of current dataset
	BOOL OnActiveDatasetChange( void )
	{
		GraphPage	activeGraph = Project.Pages();
		string strName = "NULL";
		
		if(activeGraph)
		{	
			using actCuv = Project.ActiveCurve();				
			if(actCuv.IsValid()) // maybe NULL
			{
				actCuv.GetName(strName);
			}
		}
		m_cntrlActiveCurve.Text = strName;
	
		return TRUE;
	}
	
	// change the selection 
	BOOL OnSelectionChange(void)
	{
		out_str("OnSelectionChange");
		return TRUE;
	}
	/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	BOOL OnOriginModify(WorksheetPage wkPage, int nKind)
	{
		if(wkPage)
		{
			string strPageName;
			wkPage.GetName(strPageName);
			printf("Page %s modified\n", strPageName);
		}
		out_str("OnOriginModify");
		return TRUE;
	}
	//----------------------------
	
	//----- CPY 10/27/2007 QA70-10600 PAGE_CREATE_DESTROY_MSGS
	BOOL OnPageCreate(Page pg, DWORD dwCntrl)
	{
		return true;
	}
	BOOL OnPageDestroy(Page pg, DWORD dwCntrl)
	{
		printf("OnPageDestroy:%s, %d\n", pg.GetName(), dwCntrl);
		return true;
	}
	//-----
	
	BOOL OnColFormatChange(string strWksName, string strColName, int nColNum)
	{
		printf("Col Format Change, %s:%s(%d)\n", strWksName, strColName, nColNum);
		return TRUE;
	}
	
	BOOL OnPlotAsChange(string strWksName, string strColName, int nColNum)
	{
		printf("Plot As change, %s:%s(%d)\n", strWksName, strColName, nColNum);
		return TRUE;
	}
	
private:
	Control m_cntrlActivePage;
	Control m_cntrlActiveCurve;

};